//
//  YHTestViewController.swift
//  galaxy
//
//  Created by edy on 2024/8/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHMyTestViewController: YHBaseViewController {

    lazy var sectionItems:[[ASAttributedString]] = {
        
       return [
                [self.getTextWithType(type: 0),
                 self.getTextWithType(type: 1)],
                
                [self.getTextWithType(type: 2)],
                
                [self.getTextWithType(type: 3),
                 self.getTextWithType(type: 4)],
                
                [self.getTextWithType(type: 3),
                 self.getTextWithType(type: 4)],
        ]
    }()
    
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame:.zero, style:.grouped)
        tableView.estimatedSectionHeaderHeight = 16.0
        tableView.estimatedSectionFooterHeight = 0.01
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = UIColor(hex: 0xF8F9FB)
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHTravelCertificateTipsCell.self, forCellReuseIdentifier: YHTravelCertificateTipsCell.cellReuseIdentifier)
        tableView.register(YHTravelCertificateUploadCell.self, forCellReuseIdentifier: YHTravelCertificateUploadCell.cellReuseIdentifier)
        
        return tableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.gk_navTitle = "旅行证件准备"
        self.view.backgroundColor = .white
        self.view.addSubview(self.tableView)
        self.tableView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(0)
        }
    }
    
    func getTextWithType(type: Int) -> ASAttributedString  {
        
        if type ==  0 {
           return .init("上传《港澳通行证》(需有效期≥dd-mm-yyyy)", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        
        if type == 1 {
            let a = ASAttributedString.init("办理逗留D签注", .font(UIFont.PFSC_R(ofSize:14)), .foreground(UIColor.mainTextColor(alpha: 0.5)))
            let b = ASAttributedString.init("《港澳通行证逗留 (D) -办理操作指引》", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.brandMainColor))
            let c = ASAttributedString.init("点击查看", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
            return a+b+c
        }
        
        if type == 2 {
            return .init("上传《护照》(需有效期≥签证时长+3个月)", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        
        if type == 3 {
            return .init("上传《护照》(需有效期≥dd-mm-yyyy)", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        
        if type == 4 {
            return .init("上传中国居留许可签证", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        return .init("", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
    }

}

extension YHMyTestViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return sectionItems.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
            
        
        if indexPath.section == 3 {
            
            let cell = tableView.dequeueReusableCell(withIdentifier: YHTravelCertificateUploadCell.cellReuseIdentifier, for: indexPath) as! YHTravelCertificateUploadCell
            return cell
        }
        
        let cell = tableView.dequeueReusableCell(withIdentifier: YHTravelCertificateTipsCell.cellReuseIdentifier, for: indexPath) as! YHTravelCertificateTipsCell
        
        if 0 <= indexPath.section && indexPath.section < sectionItems.count {
            let arr = sectionItems[indexPath.section]
            cell.tipsArr = arr
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        if 0 <= indexPath.section && indexPath.section < sectionItems.count {
            
        }
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 16.0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
}
